/////////////////////////////////////////////////////////////////////////////
// Name:        wxGoogleTranslateClientMainFrame.cpp
// Purpose:     
// Author:      Volodymir (T-Rex) Tryapichko
// Modified by: 
// Created:     31/10/2008 14:27:09
// RCS-ID:      
// Copyright:   Volodymir (T-Rex) Tryapichko, 2008
// Licence:     
/////////////////////////////////////////////////////////////////////////////

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "wxGoogleTranslateClientMainFrame.h"
#include "wxGoogleTranslate.h"

////@begin XPM images
////@end XPM images


/*!
 * wxGoogleTranslateClientMainFrame type definition
 */

IMPLEMENT_CLASS( wxGoogleTranslateClientMainFrame, wxFrame )


/*!
 * wxGoogleTranslateClientMainFrame event table definition
 */

BEGIN_EVENT_TABLE( wxGoogleTranslateClientMainFrame, wxFrame )

////@begin wxGoogleTranslateClientMainFrame event table entries
    EVT_BUTTON( ID_TRANSLATE, wxGoogleTranslateClientMainFrame::OnTRANSLATEClick )
    EVT_UPDATE_UI( ID_TRANSLATE, wxGoogleTranslateClientMainFrame::OnTRANSLATEUpdate )

////@end wxGoogleTranslateClientMainFrame event table entries

END_EVENT_TABLE()


/*!
 * wxGoogleTranslateClientMainFrame constructors
 */

wxGoogleTranslateClientMainFrame::wxGoogleTranslateClientMainFrame()
{
    Init();
}

wxGoogleTranslateClientMainFrame::wxGoogleTranslateClientMainFrame( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
    Init();
    Create( parent, id, caption, pos, size, style );
}


/*!
 * wxGoogleTranslateClientMainFrame creator
 */

bool wxGoogleTranslateClientMainFrame::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin wxGoogleTranslateClientMainFrame creation
    wxFrame::Create( parent, id, caption, pos, size, style );

    CreateControls();
    Centre();
////@end wxGoogleTranslateClientMainFrame creation
    return true;
}


/*!
 * wxGoogleTranslateClientMainFrame destructor
 */

wxGoogleTranslateClientMainFrame::~wxGoogleTranslateClientMainFrame()
{
////@begin wxGoogleTranslateClientMainFrame destruction
////@end wxGoogleTranslateClientMainFrame destruction
}


/*!
 * Member initialisation
 */

void wxGoogleTranslateClientMainFrame::Init()
{
////@begin wxGoogleTranslateClientMainFrame member initialisation
    m_SourceTextCtrl = NULL;
    m_SourceLanguageChoice = NULL;
    m_ResultLanguageChoice = NULL;
    m_ResultTextCtrl = NULL;
////@end wxGoogleTranslateClientMainFrame member initialisation
}


/*!
 * Control creation for wxGoogleTranslateClientMainFrame
 */

void wxGoogleTranslateClientMainFrame::CreateControls()
{    
////@begin wxGoogleTranslateClientMainFrame content construction
    wxGoogleTranslateClientMainFrame* itemFrame1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
    itemFrame1->SetSizer(itemBoxSizer2);

    wxPanel* itemPanel3 = new wxPanel( itemFrame1, ID_PANEL, wxDefaultPosition, wxDefaultSize, wxNO_BORDER|wxTAB_TRAVERSAL );
    itemBoxSizer2->Add(itemPanel3, 1, wxGROW, 0);

    wxGridBagSizer* itemGridBagSizer4 = new wxGridBagSizer(0, 0);
    itemGridBagSizer4->AddGrowableRow(0);
    itemGridBagSizer4->AddGrowableRow(3);
    itemGridBagSizer4->AddGrowableCol(1);
    itemGridBagSizer4->SetEmptyCellSize(wxSize(10, 20));
    itemPanel3->SetSizer(itemGridBagSizer4);

    m_SourceTextCtrl = new wxTextCtrl( itemPanel3, ID_SOURCE_TEXTCTRL, _T(""), wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE );
    itemGridBagSizer4->Add(m_SourceTextCtrl, wxGBPosition(0, 0), wxGBSpan(1, 2), wxGROW|wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxTOP, 5);

    wxStaticText* itemStaticText6 = new wxStaticText( itemPanel3, wxID_STATIC, _("From:"), wxDefaultPosition, wxDefaultSize, 0 );
    itemGridBagSizer4->Add(itemStaticText6, wxGBPosition(1, 0), wxGBSpan(1, 1), wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL|wxLEFT|wxTOP|wxBOTTOM, 5);

    wxArrayString m_SourceLanguageChoiceStrings;
    m_SourceLanguageChoice = new wxChoice( itemPanel3, ID_SOURCE_LANGUAGE_CHOICE, wxDefaultPosition, wxDefaultSize, m_SourceLanguageChoiceStrings, 0 );
    itemGridBagSizer4->Add(m_SourceLanguageChoice, wxGBPosition(1, 1), wxGBSpan(1, 1), wxGROW|wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxTOP, 5);

    wxStaticText* itemStaticText8 = new wxStaticText( itemPanel3, wxID_STATIC, _("To:"), wxDefaultPosition, wxDefaultSize, 0 );
    itemGridBagSizer4->Add(itemStaticText8, wxGBPosition(2, 0), wxGBSpan(1, 1), wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL|wxLEFT|wxTOP|wxBOTTOM, 5);

    wxArrayString m_ResultLanguageChoiceStrings;
    m_ResultLanguageChoice = new wxChoice( itemPanel3, ID_RESULT_LANGUAGE_CHOICE, wxDefaultPosition, wxDefaultSize, m_ResultLanguageChoiceStrings, 0 );
    itemGridBagSizer4->Add(m_ResultLanguageChoice, wxGBPosition(2, 1), wxGBSpan(1, 1), wxGROW|wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxTOP, 5);

    m_ResultTextCtrl = new wxTextCtrl( itemPanel3, ID_RESULT_TEXTCTRL, _T(""), wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxTE_READONLY );
    itemGridBagSizer4->Add(m_ResultTextCtrl, wxGBPosition(3, 0), wxGBSpan(1, 2), wxGROW|wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxTOP, 5);

    wxButton* itemButton11 = new wxButton( itemPanel3, ID_TRANSLATE, _("Translate"), wxDefaultPosition, wxDefaultSize, 0 );
    itemGridBagSizer4->Add(itemButton11, wxGBPosition(4, 0), wxGBSpan(1, 2), wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5);

////@end wxGoogleTranslateClientMainFrame content construction
	FillLanguageChoice(m_SourceLanguageChoice);
	FillLanguageChoice(m_ResultLanguageChoice);
}


/*!
 * Should we show tooltips?
 */

bool wxGoogleTranslateClientMainFrame::ShowToolTips()
{
    return true;
}

/*!
 * Get bitmap resources
 */

wxBitmap wxGoogleTranslateClientMainFrame::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin wxGoogleTranslateClientMainFrame bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end wxGoogleTranslateClientMainFrame bitmap retrieval
}

/*!
 * Get icon resources
 */

wxIcon wxGoogleTranslateClientMainFrame::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin wxGoogleTranslateClientMainFrame icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end wxGoogleTranslateClientMainFrame icon retrieval
}


/*!
 * wxEVT_UPDATE_UI event handler for ID_TRANSLATE
 */

void wxGoogleTranslateClientMainFrame::OnTRANSLATEUpdate( wxUpdateUIEvent& event )
{
    event.Enable(!m_SourceTextCtrl->GetValue().IsEmpty() &&
        (m_SourceLanguageChoice->GetSelection() >= 0) &&
        (m_ResultLanguageChoice->GetSelection() >= 0) &&
		((m_SourceLanguageChoice->GetSelection() - m_ResultLanguageChoice->GetSelection()) != 0));
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_TRANSLATE
 */

void wxGoogleTranslateClientMainFrame::OnTRANSLATEClick( wxCommandEvent& event )
{
	do
	{
		wxString result;
		wxString details;
		int errorCode(0);
		int sourceLangselection = m_SourceLanguageChoice->GetSelection();
		int resultLangselection = m_ResultLanguageChoice->GetSelection();
		if((sourceLangselection < 0) || (resultLangselection < 0)) break;
		if(wxGoogleTranslate::Translate(m_SourceTextCtrl->GetValue(), 
			result, 
			wxGoogleTranslate::GetLanguageCode(
				m_SourceLanguageChoice->GetString(sourceLangselection)), 
			wxGoogleTranslate::GetLanguageCode(
			m_ResultLanguageChoice->GetString(resultLangselection)), 
				details, errorCode))
		{
			m_ResultTextCtrl->SetValue(result);
		}
		else
		{
			wxMessageBox(wxString::Format(_("Erorr occured: %s"), details.GetData()));
		}
	}
	while(false);
}

void wxGoogleTranslateClientMainFrame::FillLanguageChoice(wxChoice * choice)
{
	wxArrayString names;
	wxGoogleTranslate::GetLanguages(names);
	choice->Clear();
	for(size_t i = 0; i < names.Count(); i++)
	{
		choice->Append(names[i]);
	}
	if(choice->GetCount() > 0)
	{
		choice->SetSelection(choice->GetCount()-1);
	}
}
