/******************************************************************************

   test_assert.cpp

    test the redfinition of the wxASSERT macro
    Copyright (C) 2007  Luciano Cattani

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


 The wxJSON library uses wxASSERT in several functions. In order to
 test them, the wxASSERT macro has to be redefined otherwise it
 causes the application to quit.

 This application redefines wxASSERT so that it can fail more than
 ont time: instrad of a program termination, the failed condition
 cause the application to print a message


 Syntax:

   test_assert.bin



 jul 2008
 --------
 The test is not successfull. I get SEGMENTATION FAULT

*****************************************************************************/

// using namespace std;

//#ifdef __GNUG__
//    #pragma implementation "skeleton.cpp"
//#endif


#include <wx/string.h>
#include <wx/app.h>
#include <wx/log.h>
#include <wx/debug.h>
#include <wx/ffile.h>


#if defined( wxASSERT )
 #undef wxASSERT
#endif

#define wxASSERT( cond )		\
	if ( !(cond) ) {		\
		wxString s;		\
		s.Printf( _T("(%s) Line: %d - ASSERTION failure: %s"),	\
			_T(__FILE__), __LINE__, wxSTRINGIZE_T( cond ));	\
		TestCout( s);		\
	}


static wxFFile* gs_cout = 0;

void TestCout( const wxChar* str )
{
  wxString s( str );
  TestCout( s );
}

void TestCout( const wxString& str )
{
  gs_cout->Write( str );
}



int main( int argc, char* argv[] ) 
{
  // the following is mandatory for a console app.
  bool r = ::wxInitialize();
  if ( !r )   {
    printf( "FATAL ERROR: cannot init wxBase library\n");
    return 1;
  }

  // write output to STDOUT
  gs_cout = new wxFFile( stdout );
  TestCout( _T( "\nTEST application: wxASSERT redefinition\n\n" ));

  int a = 0, b = 0, c = 0;

  wxASSERT( a == 1 );

  wxASSERT( b == 2 );

  wxASSERT( c == 3 );


  TestCout( _T( "\nTEST application successfully completed\n\n" ));
  ::wxUninitialize();
  return 0;
}


/*
{
}
*/

